<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAvailabilitiesTable extends Migration {

	public function up()
	{
		Schema::create('availabilities', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('professional_id')->unsigned();
			$table->bigInteger('shop_id')->unsigned();
			$table->string('monday', 191);
			$table->boolean('is_monday');
			$table->string('tuesday');
			$table->boolean('is_tuesday');
			$table->string('wednesday', 191);
			$table->boolean('is_wednesday');
			$table->string('thursday', 191);
			$table->boolean('is_thursday');
			$table->string('friday', 191);
			$table->boolean('is_friday');
			$table->string('saturday', 191);
			$table->boolean('is_saturday');
			$table->string('sunday', 191);
			$table->boolean('is_sunday');
			$table->boolean('is_for_shop');
			$table->boolean('is_for_indep_pro');
			$table->boolean('is_for_normal_user');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('availabilities');
	}
}