<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->text('name');
			$table->text('email')->unique();
			$table->timestamp('email_verified_at')->nullable();
			$table->string('password');
			$table->text('remember_token');
			$table->integer('id_roles')->unsigned()->default('1');
			$table->integer('is_approved_admin')->default('0');
			$table->string('no_hp')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}