<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTBanksTable extends Migration {

	public function up()
	{
		Schema::create('t_banks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('number');
			$table->date('date');
			$table->integer('Check_num');
			$table->tinyInteger('type')->default('0');
			$table->decimal('price');
			$table->string('beneficiary', 191);
			$table->string('owner_acc', 191);
			$table->date('due_date');
			$table->string('name', 191);
			$table->string('Check_owner', 191);
			$table->bigInteger('bank_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('t_banks');
	}
}