<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Thread extends Eloquent {

	protected $table = 'threads';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function posts()
	{
		return $this->hasMany('Post');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function channel()
	{
		return $this->belongsTo('Channel');
	}

	public function notifications()
	{
		return $this->hasMany('Notification');
	}

}