<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWashedEventsTable extends Migration {

	public function up()
	{
		Schema::create('washed_events', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('washed_id')->unsigned();
			$table->string('description', 150);
			$table->bigInteger('user_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('washed_events');
	}
}