<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('franchisees', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('franchisees', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('states')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('machines', function(Blueprint $table) {
			$table->foreign('station_id')->references('id')->on('stations')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('machines', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('status')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('stations', function(Blueprint $table) {
			$table->foreign('franchisee_id')->references('id')->on('franchisees')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('washes', function(Blueprint $table) {
			$table->foreign('machine_id')->references('id')->on('machines')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('washes', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('washes', function(Blueprint $table) {
			$table->foreign('washed_type_id')->references('id')->on('washed_types')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('washed_events', function(Blueprint $table) {
			$table->foreign('washed_id')->references('id')->on('washes')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('supply_history', function(Blueprint $table) {
			$table->foreign('station_id')->references('id')->on('stations')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('supply_history', function(Blueprint $table) {
			$table->foreign('supply_type_id')->references('id')->on('supplies')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('supply_history', function(Blueprint $table) {
			$table->foreign('washed_id')->references('id')->on('washes')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('franchisees', function(Blueprint $table) {
			$table->dropForeign('franchisees_state_id_foreign');
		});
		Schema::table('franchisees', function(Blueprint $table) {
			$table->dropForeign('franchisees_country_id_foreign');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->dropForeign('states_country_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_state_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_country_id_foreign');
		});
		Schema::table('machines', function(Blueprint $table) {
			$table->dropForeign('machines_station_id_foreign');
		});
		Schema::table('machines', function(Blueprint $table) {
			$table->dropForeign('machines_status_id_foreign');
		});
		Schema::table('stations', function(Blueprint $table) {
			$table->dropForeign('stations_franchisee_id_foreign');
		});
		Schema::table('washes', function(Blueprint $table) {
			$table->dropForeign('washes_machine_id_foreign');
		});
		Schema::table('washes', function(Blueprint $table) {
			$table->dropForeign('washes_client_id_foreign');
		});
		Schema::table('washes', function(Blueprint $table) {
			$table->dropForeign('washes_washed_type_id_foreign');
		});
		Schema::table('washed_events', function(Blueprint $table) {
			$table->dropForeign('washed_events_washed_id_foreign');
		});
		Schema::table('supply_history', function(Blueprint $table) {
			$table->dropForeign('supply_history_station_id_foreign');
		});
		Schema::table('supply_history', function(Blueprint $table) {
			$table->dropForeign('supply_history_supply_type_id_foreign');
		});
		Schema::table('supply_history', function(Blueprint $table) {
			$table->dropForeign('supply_history_washed_id_foreign');
		});
	}
}