<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function collections()
	{
		return $this->hasMany('Collection');
	}

	public function posts()
	{
		return $this->hasMany('Post');
	}

	public function uploads()
	{
		return $this->hasMany('Upload');
	}

}