<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehiclesTable extends Migration {

	public function up()
	{
		Schema::create('vehicles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user')->unsigned();
			$table->string('licence');
			$table->integer('category')->unsigned();
			$table->integer('maker')->unsigned();
			$table->integer('model')->unsigned();
			$table->string('version')->nullable();
			$table->date('year')->nullable();
			$table->timestamps();
			$table->enum('color', array('white', 'silver', 'gray', 'black', 'navyblue', 'cerulean', 'skyblue', 'turquoise', 'blue', 'green', 'azure', 'teal', 'cyan', 'green', 'lime', 'chartreuse', 'olive', 'yellow', 'gold', 'amber', 'orange', 'brown', 'orange-red', 'red', 'maroon', 'rose', 'red', 'violet', 'pink', 'magenta', 'purple', 'blueviolet', 'indigo', 'violet	', 'peach', 'apricot'));
		});
	}

	public function down()
	{
		Schema::drop('vehicles');
	}
}