<?php

namespace booking;

use Illuminate\Database\Eloquent\Model;

class Booking extends Model 
{

    protected $table = 'booking';
    public $timestamps = true;

    public function doctorBooking()
    {
        return $this->belongsTo('Doctor');
    }

    public function Consultation()
    {
        return $this->hasOne('Consultation');
    }

    public function Prescription()
    {
        return $this->hasMany('Prescription');
    }

    public function MedicalX-ray()
    {
        return $this->hasMany('MedicalRequest');
    }

}