<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConsultationTable extends Migration {

	public function up()
	{
		Schema::create('consultation', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('bookingId');
			$table->text('patientDescription');
			$table->text('doctorDescription');
			$table->text('doctorRecommendation');
			$table->string('prescriptionImage', 100);
			$table->boolean('prescriptionRenewal')->default(0);
			$table->date('prescriptionRenewalDate');
		});
	}

	public function down()
	{
		Schema::drop('consultation');
	}
}