<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorTable extends Migration {

	public function up()
	{
		Schema::create('doctor', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('firstName', 30);
			$table->string('lastName', 30);
			$table->string('email', 50);
			$table->string('phone', 20);
			$table->string('password', 50);
			$table->date('birthDate');
			$table->string('country', 50);
			$table->string('state', 50);
			$table->string('city', 50);
			$table->boolean('verifyAccount')->default(0);
			$table->string('workingHoursSetting', 50);
			$table->boolean('gender')->default(0);
			$table->string('professionalTitle');
			$table->string('fullProfessionalTitle');
		});
	}

	public function down()
	{
		Schema::drop('doctor');
	}
}