<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceItemTable extends Migration {

	public function up()
	{
		Schema::create('invoice_item', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('invoice_id')->nullable();
			$table->text('details')->nullable();
			$table->integer('quantity')->nullable();
			$table->double('price')->nullable();
			$table->double('total')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invoice_item');
	}
}