<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceTable extends Migration {

	public function up()
	{
		Schema::create('invoice', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('customer_name')->nullable();
			$table->string('phone')->nullable();
			$table->datetime('date')->nullable();
			$table->string('country')->nullable();
			$table->string('city')->nullable();
			$table->string('container_number')->nullable();
			$table->text('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invoice');
	}
}