<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'client';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('account_number', 'name', 'fax', 'phone', 'mobile', 'mark', 'company', 'country_id', 'city_id', 'user_id');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function client_funds()
    {
        return $this->hasMany('ClientFund', 'client_id');
    }

}