<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientFund extends Model 
{

    protected $table = 'client_fund';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('client_id', 'currency_id', 'amount');

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

    public function currency()
    {
        return $this->belongsTo('Currency', 'currency_id');
    }

    public function client_fund_histories()
    {
        return $this->hasMany('ClientFundHistory', 'client_fund_id');
    }

}