<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorPackageTable extends Migration {

	public function up()
	{
		Schema::create('vendor_package', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 50);
			$table->string('description', 100);
			$table->float('price', 8,2);
			$table->integer('vendor_role');
			$table->char('state', 3);
			$table->boolean('package_type');
			$table->integer('ordering');
			$table->string('icon', 150);
			$table->tinyInteger('status');
			$table->integer('created_by');
			$table->integer('updated_by');
			$table->timestamp('deleted_at');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vendor_package');
	}
}