<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Beneficiary_service extends Eloquent {

	protected $table = 'beneficiary_services';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('beneficiary_id', 'note');

	public function beneficiary()
	{
		return $this->belongsTo('Beneficiary');
	}

	public function service()
	{
		return $this->belongsTo('Service');
	}

}