<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Volunteer extends Eloquent {

	protected $table = 'volunteers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('note');

	public function user()
	{
		return $this->belongsTo('UserInfo');
	}

	public function logs()
	{
		return $this->hasMany('Volunteer_log', 'volunteer_id');
	}

}