<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_wallet', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_relation', function(Blueprint $table) {
			$table->foreign('follower_user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_relation', function(Blueprint $table) {
			$table->foreign('following_user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_wallet_log', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_bank_account', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_visitor', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_visitor', function(Blueprint $table) {
			$table->foreign('visitor_user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_category', function(Blueprint $table) {
			$table->foreign('main_category')->references('id')->on('category')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('advert_category', function(Blueprint $table) {
			$table->foreign('main_category')->references('id')->on('category')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('product_category')->references('id')->on('product_category')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_item', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('advert', function(Blueprint $table) {
			$table->foreign('advert_category')->references('id')->on('advert_category')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('category_detail', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_rewiews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_rewiews', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('user_wallet', function(Blueprint $table) {
			$table->dropForeign('user_wallet_user_id_foreign');
		});
		Schema::table('user_relation', function(Blueprint $table) {
			$table->dropForeign('user_relation_follower_user_id_foreign');
		});
		Schema::table('user_relation', function(Blueprint $table) {
			$table->dropForeign('user_relation_following_user_id_foreign');
		});
		Schema::table('user_wallet_log', function(Blueprint $table) {
			$table->dropForeign('user_wallet_log_user_id_foreign');
		});
		Schema::table('user_bank_account', function(Blueprint $table) {
			$table->dropForeign('user_bank_account_user_id_foreign');
		});
		Schema::table('user_visitor', function(Blueprint $table) {
			$table->dropForeign('user_visitor_user_id_foreign');
		});
		Schema::table('user_visitor', function(Blueprint $table) {
			$table->dropForeign('user_visitor_visitor_user_id_foreign');
		});
		Schema::table('product_category', function(Blueprint $table) {
			$table->dropForeign('product_category_main_category_foreign');
		});
		Schema::table('advert_category', function(Blueprint $table) {
			$table->dropForeign('advert_category_main_category_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_product_category_foreign');
		});
		Schema::table('product_item', function(Blueprint $table) {
			$table->dropForeign('product_item_product_id_foreign');
		});
		Schema::table('advert', function(Blueprint $table) {
			$table->dropForeign('advert_advert_category_foreign');
		});
		Schema::table('category_detail', function(Blueprint $table) {
			$table->dropForeign('category_detail_category_id_foreign');
		});
		Schema::table('product_rewiews', function(Blueprint $table) {
			$table->dropForeign('product_rewiews_user_id_foreign');
		});
		Schema::table('product_rewiews', function(Blueprint $table) {
			$table->dropForeign('product_rewiews_product_id_foreign');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->dropForeign('product_images_product_id_foreign');
		});
	}
}