<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function productCategories()
	{
		return $this->hasMany('ProductCategory', 'main_category');
	}

	public function advertCategories()
	{
		return $this->hasMany('AdvertCategory', 'main_category');
	}

	public function categoryDetails()
	{
		return $this->hasMany('CategoryDetail', 'category_id');
	}

}