<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientsTable extends Migration {

	public function up()
	{
		Schema::create('patients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('phone', 191);
			$table->integer('area_id');
			$table->date('birthdate');
			$table->enum('gender', array('male', 'female'));
			$table->string('name', 191);
			$table->string('notes', 191);
			$table->string('email', 191);
			$table->integer('clinic_id');
			$table->integer('insurance_id');
		});
	}

	public function down()
	{
		Schema::drop('patients');
	}
}