<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 191);
			$table->string('username', 191);
			$table->string('password', 191);
			$table->string('email', 191);
			$table->integer('clinic_id');
			$table->enum('job', array('doctor', 'nurse', 'secretary'));
			$table->string('phonenumber', 191);
			$table->boolean('active');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}