<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartItemOptionsTable extends Migration {

	public function up()
	{
		Schema::create('cart_item_options', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('cart_id')->unsigned();
			$table->bigInteger('optionable_id')->unsigned();
			$table->string('optionable_type');
			$table->decimal('price', 10,2)->default('0');
		});
	}

	public function down()
	{
		Schema::drop('cart_item_options');
	}
}