<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfficesTable extends Migration {

	public function up()
	{
		Schema::create('offices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('office_name', 125);
			$table->text('office_description');
			$table->string('office_email')->unique();
			$table->string('office_website');
			$table->decimal('Longitude');
			$table->date('office_opening_date');
			$table->string('office_logo');
			$table->string('office_license');
			$table->string('office_phone_1', 125)->unique();
			$table->string('office_phone_2', 125)->unique();
			$table->string('office_phone_3', 125)->unique();
			$table->decimal('latitude');
		});
	}

	public function down()
	{
		Schema::drop('offices');
	}
}