<?php

namespace App\Models\Xcase;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Xcase extends Eloquent {

	protected $table = 'xcases';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('case_uuid', 'client_id', 'opponent_name', 'opponent_description', 'client_description', 'case_registration', 'case_registration_date', 'court_degree_id', 'court_item_id');

	public function judgment()
	{
		return $this->hasMany('Judgment');
	}

	public function casefile()
	{
		return $this->hasMany('CaseFileItem');
	}

	public function subject()
	{
		return $this->hasMany('SubjectItems');
	}

	public function caseSetting()
	{
		return $this->belongsTo('CaseSetting');
	}

	public function caseSetting()
	{
		return $this->belongsTo('CaseSetting');
	}

	public function caseExpenses()
	{
		return $this->belongsTo('CaseExpense');
	}

}