<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Rating extends Eloquent {

	protected $table = 'ratings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('store_id');

	public function user()
	{
		return $this->belongsTo('User', 'placed_by');
	}

	public function product()
	{
		return $this->belongsTo('Product', 'product_id');
	}

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

}