<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Driver extends Eloquent {

	protected $table = 'driver';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'branch_id', 'name', 'status', 'busy');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function branch()
	{
		return $this->belongsTo('Branch', 'branch_id');
	}

	public function ratings()
	{
		return $this->hasMany('Rating', 'driver_id');
	}

}