<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Offer extends Eloquent {

	protected $table = 'offer';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('product_id', 'title_en', 'title_ar', 'message_en', 'message_ar', 'button_en', 'button_ar');

	public function product()
	{
		return $this->belongsTo('Product', 'product_id');
	}

}