<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationTable extends Migration {

	public function up()
	{
		Schema::create('notification', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->string('title_en')->nullable();
			$table->string('title_ar')->nullable();
			$table->boolean('broadcast')->nullable()->default(0);
			$table->text('message_en')->nullable();
			$table->text('message_ar')->nullable();
			$table->boolean('read')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('notification');
	}
}