<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateComplexesTable extends Migration {

	public function up()
	{
		Schema::create('complexes', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('status')->nullable()->default(1);
			$table->string('name', 255)->nullable();
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->bigInteger('city_id')->unsigned();
			$table->string('tax_number', 255)->nullable();
			$table->string('customer_support')->nullable();
			$table->bigInteger('package_id')->nullable();
			$table->string('lat')->nullable();
			$table->string('lon');
			$table->text('address')->nullable();
			$table->timestamp('start')->nullable();
			$table->timestamp('end');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('complexes');
	}
}