<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->increments('id');
			$table->decimal('price')->nullable();
			$table->string('bookings_count')->nullable();
			$table->decimal('saving_amount')->nullable();
			$table->integer('duration')->nullable();
			$table->enum('duration_type', array('day', 'month', 'year'))->nullable();
			$table->tinyInteger('status')->nullable()->default('1');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}