<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePacsDataTable extends Migration {

	public function up()
	{
		Schema::create('pacs_data', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('tenant_id')->unsigned();
			$table->string('special_char')->nullable();
			$table->string('study_date')->nullable();
			$table->string('study_time')->nullable();
			$table->string('accession_no')->nullable();
			$table->string('ea_title');
			$table->string('instance_availability')->nullable();
			$table->string('modalities_study')->nullable();
			$table->string('study_description')->nullable();
			$table->string('physician_name')->nullable();
			$table->string('patient_name')->nullable();
			$table->string('patient_id')->nullable();
			$table->string('patient_birthdate')->nullable();
			$table->string('patient_sex')->nullable();
			$table->string('study_instance_uid')->nullable();
			$table->string('study_id')->nullable();
			$table->string('number_study_series')->nullable();
			$table->string('number_study_instance')->nullable();
			$table->string('patient_file')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('pacs_data');
	}
}