<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProviderWorkingDaysTable extends Migration {

	public function up()
	{
		Schema::create('provider_working_days', function(Blueprint $table) {
			$table->bigIncrements('id', true)->primary();
			$table->timestamps();
			$table->enum('day', array('saturday', 'sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday'))->index();
			$table->time('time_from')->nullable();
			$table->string('time_to')->nullable();
			$table->boolean('opened')->default(0);
			$table->bigInteger('provider_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('provider_working_days');
	}
}