<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Team extends Eloquent {

	protected $table = 'teams';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function members()
	{
		return $this->hasMany('App\Models\TeamMembers');
	}

	public function match()
	{
		return $this->belongsToMany('App\Models\Match');
	}

	public function media()
	{
		return $this->hasMany('App\Models\Media');
	}

	public function news()
	{
		return $this->hasMany('New');
	}

}