<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name');
			$table->string('last_name');
			$table->date('birthdate');
			$table->string('phone');
			$table->string('email');
			$table->text('address');
			$table->integer('city_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->integer('province_id');
			$table->enum('status', array('active', 'not_active'));
			$table->enum('role', array('user', 'admin'));
			$table->enum('verified', array('0', '1'));
			$table->string('language');
			$table->text('password');
			$table->string('image')->nullable();
			$table->text('secret_token');
			$table->softDeletes();
			$table->timestamps();
			$table->text('google_id');
			$table->text('facebook_id');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}