<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->boolean('hasAuthor')->default(0,1);
			$table->boolean('hasSummary')->default(0,1);
			$table->integer('ordering');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}