<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSourcesTable extends Migration {

	public function up()
	{
		Schema::create('sources', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 64);
			$table->string('thread_id_prefix', 3);
			$table->string('type', 12);
			$table->string('base_url', 1024);
			$table->string('thread_url', 1024);
			$table->datetime('threads_last_updated');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('sources');
	}
}