<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('restaurant_id')->unsigned();
			$table->text('description');
			$table->string('image', 255)->nullable();
			$table->date('start_at');
			$table->date('end_at');
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}