<?php

namespace Post;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function author()
	{
		return $this->belongsTo('Author');
	}

	public function comments()
	{
		return $this->hasMany('Comment');
	}

	public function gallery()
	{
		return $this->hasMany('Gallery');
	}

}