<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->string('email')->unique();
			$table->date('birthdate');
			$table->integer('bloodtype_id')->unsigned();
			$table->date('lastdonation_date');
			$table->integer('city_id')->unsigned();
			$table->string('phone', 191);
			$table->string('password', 191);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}