<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerProfileTable extends Migration {

	public function up()
	{
		Schema::create('customer_profile', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->unsigned();
			$table->string('first_name', 255);
			$table->string('middle_name', 255);
			$table->string('last_name', 255);
			$table->text('address_line1');
			$table->text('address_line2');
			$table->string('city', 255);
			$table->string('state', 255);
			$table->string('zipcode', 10);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customer_profile');
	}
}