<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewFeedbackTable extends Migration {

	public function up()
	{
		Schema::create('review_feedback', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->unsigned();
			$table->integer('product_id')->unsigned();
			$table->text('review');
			$table->decimal('rating');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('review_feedback');
	}
}