<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Slider extends Eloquent {

	protected $table = 'sliders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('doctor_id', 'discount', 'next_date', 'cost', 'appointment_time');

	public function doctor()
	{
		return $this->belongsTo('App\Models\Doctor');
	}

}