<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHighlightsTable extends Migration {

	public function up()
	{
		Schema::create('highlights', function(Blueprint $table) {
			$table->increments('id');
			$table->string('heading', 50)->nullable();
			$table->date('date')->nullable();
			$table->string('name')->nullable();
			$table->bigInteger('speaker_id')->unsigned();
			$table->string('video_link', 50)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('highlights');
	}
}