<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Employee extends Model 
{

    protected $table = 'employees';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function nationality()
    {
        return $this->belongsTo('Nationality', 'nationality_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

    public function nationalism()
    {
        return $this->belongsTo('Nationalism', 'nationalism_id');
    }

    public function classification()
    {
        return $this->belongsTo('Classification', 'group_id');
    }

}