<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PricingRequest extends Model 
{

    protected $table = 'pricing_requests';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function storageDuratipn()
    {
        return $this->hasOne('StorageDuration');
    }

    public function storgeType()
    {
        return $this->hasOne('StorageType');
    }

    public function storageTemp()
    {
        return $this->hasOne('StorageTemprature');
    }

    public function User()
    {
        return $this->belongsTo('User');
    }

}