<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePointOfSellSessions5Table extends Migration {

	public function up()
	{
		Schema::create('point_of_sell_sessions5', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('client_point_of_sell_id')->unsigned()->nullable();
			$table->bigInteger('total_orders')->default('0');
			$table->bigInteger('total_products')->default('0');
			$table->bigInteger('total_prices')->default('0');
			$table->string('start_time')->nullable();
			$table->string('end_time')->nullable();
			$table->integer('number_of_stops')->default('0');
			$table->enum('is_hold', array('yes-no'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('point_of_sell_sessions5');
	}
}