<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuppliers3Table extends Migration {

	public function up()
	{
		Schema::create('suppliers3', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('consumer_type_id')->unsigned()->nullable();
			$table->bigInteger('currency_id')->unsigned()->nullable();
			$table->string('name')->nullable();
			$table->string('email')->nullable();
			$table->string('phone')->nullable();
			$table->enum('gender', array('1=male', '2=female'));
			$table->string('code')->nullable();
			$table->timestamps();
			$table->string('credit_limit')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('suppliers3');
	}
}