<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWarehouseTransactions7Table extends Migration {

	public function up()
	{
		Schema::create('warehouse_transactions7', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('from_warehouse_id')->unsigned()->nullable();
			$table->bigInteger('to_warehouse_id')->unsigned()->nullable();
			$table->bigInteger('from_employee_id')->unsigned()->nullable();
			$table->bigInteger('to_employee_id')->unsigned()->nullable();
			$table->bigInteger('invoiceable')->unsigned();
			$table->string('date')->nullable();
			$table->string('time_sale')->nullable();
			$table->string('arrival_time')->nullable();
			$table->string('receive_time')->nullable();
			$table->enum('status', array('0=pending', '1=accepted', '2=rejected', '3=>returned'));
			$table->enum('type', array('0=inside', '1=outside', '2=>purchase'));
			$table->text('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('warehouse_transactions7');
	}
}