<?php

namespace Country;

use Illuminate\Database\Eloquent\Model;

class Country extends Model 
{

    protected $table = 'countries';
    public $timestamps = true;
    protected $fillable = array('name', 'code', 'flag', 'available');

    public function users()
    {
        return $this->hasMany('User', 'country_id');
    }

    public function state()
    {
        return $this->hasMany('State', 'country_id');
    }

}